.H 1 "Remote Unix Pi Window"
This window debugs Unix processes on remote processors and provides 
the same interface as pi's Unix Pi window.
Designed primarily as a tool for porting pi to new architectures,
the Remote Unix Pi window allows a single instance of rtpi to
control processes concurrently on multiple, heterogeneous, Unix systems.
Onlys a small debug server runs on the target machine.
Once pi has been successfully ported to a machine, its remote
execution options may be used instead.
.P
When processes are debugged with the Remote Unix Pi window,
most of the work is performed on the local system and a small
server executing on the remote processor is used for
operations that cannot be executed locally.
For example, parsing of the symbol table and manipulation of the
source files are done locally,
while the server handles requests to attach to active processes,
single step a program,
and examine the current values of the registers and memory.
The server code depends heavily on the target's architecture and 
operating system version and may be implemented with a small C program
that is easier to get working in new environments than the debugger.
.P
To operate, the Remote Unix Pi window requires that the source and
symbol table files be accessible through the local file system,
either by mounting the remote file system using a network file system,
or if one is not available, by copying the files to the local machine.
.P
The server is started on the remote processor from the Rtpi window
with the rsh command.
For example, if the remote system's Internet name is daksun and the
the server is named sun4server, the server may be started by typing
the command:
.DS I N
!rsh daksun sun4server
.DE
.P
to the Rtpi window and selecting the "open board" entry in the line menu.
This only works if:
.AL 1
.LI
You have a login on the remote system and it allows rsh to connect
without providing a password.
.LI
The server is installed on your PATH on the remote system.
.LE
.P
When the Remote Unix Pi Window is used there are two different working 
directories: the working directory of rtpi on the local system and
the working directory of the server on the remote system.
Rtpi reads the both the symbol table and source files through the local
file system, so the working directory of the server only
becomes important when:
.AL 1
.LI
A new process is started on the remote system using the "hang & open proc" or 
"hang & take over" line menu entries.
When these are selected, the string used to start the process is sent to the
server where it is started with the execp() system call.
If the name of the program is not a full path name, the server searches 
for it in the directories found in it's PATH environment variable.
If the PATH includes the current working directory,
the working directory of the server determines where the program is found.
.LI
A core dump is examined.
The server opens both the core file and the executable file
containing the symbol table.
While the server does not look at the symbol table,
when the Assembler window disassembles instructions the server 
needs to extract the compiled text section from the executable file,
as this information is not in the core dump file.
.LE
.P
To change the working directory of the server on the remote system,
use the Remote Directory window that may be opened from the menu bar.
The Working Directory window changes the working directory of rtpi.
.H 2 "Remote Unix Pi Layout"
The title bar identifies the remote system's name,
operating system name and version, and architecture.
Each line in the window represents either
a Unix process, a core dump, or a command line used to start a new process.
Lines that start with numbers, such as
.DS I N
2292 q0 S 0:55 pads
2294 test1
.DE
.P
represent Unix processes.
The number on the left of the line is the process id, while the
rest of the line is the name of the program or the output from the
Unix ps command.
Lines that start with the character `!', such as
.DS I N
! a.out
.DE
.P
start new processes under the control of the debugger.
The rest of the line is the command to run. The other lines, such as
.DS I N
core a.out
.DE
.P
open core dumps.
The file on the left is the name of the core dump and
the file on the right is the name of the program that generated it.
.P
The core dump and !command lines are typed in from the keyboard,
while lines representing Unix processes may be either typed in or
generated by running the Unix ps command from the window's "ps" menu.
By selecting a line and generating its line menu, you may attach the
debugger to the running program, examine the core dump, or start a new program.
.P
When the Remote Unix Pi window is opened it contains two default lines:
.DS I N
!a.out
core a.out
.DE
.P
that allow the program a.out to be started,
or the core dump, core, created by an errant a.out to be opened.
These lines also serve as templates to remind you of
the window's keyboard syntax.
.H 2 "Remote Unix Pi Menu Bar"
.P
The menu bar allows selected groups of processes to be listed in the window
or the Remote Directory window to be opened.
The "ps" menu contains the following entries on Unix System VR4
based systems (the entries may be slightly different with other versions
of the Unix operating system):
.VL 17 1
.LI "/bin/ps -u user"
Run the Unix command in the menu entry to generate a list of your
current processes on the remote system, and place its output in the window.
You may attach the debugger to a process
by selecting its line and using its line menu.
The lines are sorted by process id number, and previous entries
with the same process id number are removed.
.LI "/bin/ps -a"
Same as above except the processes owned by other users are also listed.
Unless you have super-user permissions on the remote system
you will not be able to attach to programs you do not own.
.LI "/bin/ps -e"
List every process on the remote system.
Only the super-user is allowed to attach
to programs owned by others.
.LE
.P
The "cd" buttons does the following:
.VL 7 1
.LI "cd"
Open the Remote Directory window.
This window is changes the working directory of the server
on the remote system, and is only be needed if a new process is started
with the "hang & open proc" or "hang & take over" line menu entries, or a core
dump is opened with "open coredump".
The working directory of the server does not affect the attachment of the
debugger to existing processes.
.LE
.H 2 "Remote Unix Pi Keyboard"
.P
Syntax
.DS I N
!program [arg1 ...]
[*]pid program
[*]corefile program
.DE
.P
The Remote Unix Pi window's keyboard interpreter accepts three
different input formats
that allow you to start a new process, attach to an existing process,
or examine a core dump.
The first format:
.DS I N
!program [arg1 ...]
.DE
.P
starts a new process.
Program is the name of the executable file that 
contains the code and symbol table information.
The optional arguments are passed to the program when it is started.
When the text is entered, rtpi adds a line to the window and selects it,
but does not start the program.
The line's menu provides options to start the program in a new Process window
or to take over an existing set of windows.
Since entering the line in the window is a separate operation from
starting the program, the same line may be used to start the
program several times.
.P
The second format:
.DS I N
[*]pid program
.DE
.P
attaches to processes that are already running.
Pid is the process id number and program is the name of the file containing
the symbol table on the local system.
Rtpi searches for the program name on your PATH.
Unlike pi's Unix Pi window, the program name is required even on systems
that support mounted processes since the debugging primitives that map
a process id number into an executable file descriptor do
not work across the network.
If not preceded by the optional `*',
the line will simply be entered in the window and you will
have to use the line's menu to attach the debugger to the process.
The line menu gives you the option of opening the process in a new set of
windows or attaching to a preexisting set, just like the menu for lines
that start with `!'.
If the entry is preceded by the character `*', a new Process window for
the process will be automatically opened when the text is entered.
`*' is an accelerator for selecting the "open process" menu entry
in the newly entered line.
.P
The third format:
.DS I N
[*]corefile program
.DE
.P
examines core dumps.
Corefile is the name of the core dump file, usually core, and program
is the name of the file containing the symbol table.
As the syntax for core dumps is the same as that used for attaching
to processes, the window distinguishes the two by the name
of the corefile.
If corefile contains only digits, rtpi assumes it is a process id.
Otherwise, its a core dump file.
If you plan to use rtpi with core dumps, don't rename the core file with
a name that contains only digits!
As above, the optional `*' is an accelerator for opening the core
dump without using the menus.
In the current implementation a core dump cannot take over an
existing set of windows.
.H 2 "Remote Unix Pi Line Menus"
.P
The line menu depends on the format of the selected line.
Lines in the format "!program [arg1 ...]" start new processes and
the menu contains the following entries:
.VL 19 1
.LI "hang & open proc"
Start the process from the server using the execp() system call,
and suspend it before it executes the first instruction.
The program may be in any directory on your PATH.
As rtpi does not provide a process with a window for terminal I/O,
the new process will have its standard input, output and error file
descriptors initialized to /dev/null.
Other than redirection of the file descriptors, this
is equivalent to using hang to start the process outside of rtpi.
After the process is created, a new Process window is opened for it and a
new entry of the form:
.DS I N
pid program
.DE
.P
where pid is the process id of the new process,
is added to the Remote Unix Pi window.
.LI "hang & take over"
This entry is similar to "hang & open proc",
except rather than creating a new set of windows,
you will be asked to choose an existing set of windows to take over.
A pop-up window will ask you to select the process window
hierarchy to take over.
To work successfully, the process chosen must be another instance of the
same program.
If successful, the debugger will detach itself from the Unix process that
window was previously connected to, and attach to the new one.
In addition to the windows, the new process inherits all the breakpoints
that were set in the previous process.
This menu entry is particularly useful if while debugging a program,
you discover you have gone too far, and would like to rerun the
program without going through the effort of opening the windows,
resetting the data formatting options, and placing the breakpoints.
.LE
.P
If the line in the window starts with a process id number,
either from a line typed to the window or from the output of the
ps command, the menu contains the following entries:
.VL 15 1
.LI "open process"
Attach the debugger to the process and open a new Process window for it.
The file containing the symbol table
must be in the current directory or somewhere on your PATH.
If the line was generated by a ps menu entry
the program name is taken from the COMMAND field.
.LI "take over"
Similar to "open process", except instead of creating a new set of
windows, you will be asked to choose an existing set of windows to take over.
.LI "open child"
Attach the debugger to the child of a debugged process.
When a process being debugged calls the Unix system call fork,
the child process inherits the parent's memory, and thus any breakpoints
that were set in the code.
When the debugger attaches to the child, the breakpoints inherited
from the parent must first be removed.
To use this entry:
.AL 1
.LI
Execute the fork() in the parent process at full speed.
.LI
Choose the "ps" entry in the menu bar.
.LI
Select the line in the window corresponding to the new child process.
.LI
Choose the "open child" entry in the line menu.
.LE
.LE
.P
If the line starts with neither `!' or a process id (all digits),
the line must be in the format used to open core dumps, "corefile program",
and the menu contains:  
.VL 17 1
.LI "open coredump"
Open the Process window for the core dump.
Corefile must be accessible from the current directory as rtpi does
not search for it on your PATH.
.LE
